clear all
load('autoco.mat');
% choose your data to be plotted, up to 6:
limpt = 10; % upper limit of persistence time
sizespot = 30-5; % spot size for the swarm plot
autocollimitmin = 0.3;
dp = [1,2];
cmap = [0.0320 0.4469 0.7564;   %color 1     (blue)
        0.9804 0.1961 0;];          
labels = {'RPE1-GFP-Rab6A','RPE1-iRFP-Rab6A-CRISPR'};
% 1 'Trajectory10x_RPE1_GFP_Rab6.mat'
% 2 'Trajectory10x_RPE1_iRFP_Rab6.mat'
%
y = [];
x = [];
loccol = [];
med =[];
count = 1;
for k=dp
%     full_name = name{k};
%     A = load(full_name);
%     short_name = full_name(1:end-4);
%     data = A.(short_name);
    Nrep = Ntraj(k);
    pt=[];
    ltt=[];
    gi = [];
    for nr=1:Nrep
        %cell(nr,k).traj = data{nr}';
        %cell(nr,k).V =  diff(cell(nr,k).traj,1,1);
        % fit
        %f = fit([1:30]',cell(nr,k).autocoor(2:31)','exp1','startpoint',[1 -1/10]);
        %f.b = -1/cell(nr,k).p;
        %if f.a<autocollimitmin
        if cell(nr,k).autocoor(2)<autocollimitmin%&cell(nr,k).p>5
            pt(nr) = 0;
        else
            pt(nr) = cell(nr,k).p;%-1/f.b;
        end
        if pt(nr)<0
            pt(nr)=0;
        end
        if pt(nr)>cell(nr,k).lt
            pt(nr)=cell(nr,k).lt;
%             figure(1)
%             clf
%             plot(f,[1:cell(nr,k).lt-1]',cell(nr,k).autocoor(2:end)')
%             ylim([0,1])
%             drawnow
%             pause(1)
        end

        pt(nr) = pt(nr)*15/60;

        if pt(nr)>0
            gi = [gi,nr];
        end

        if pt(nr)>limpt
            pt(nr)=limpt;
        end

        if isnan(pt(nr))
            pt(nr) = 0;
        end
        ltt(nr) = cell(nr,k).lt;
    end

    % compute mean autocorrelation
    lmax = [];
    for nr=1:Nrep%gi
        lmax(nr) = length(cell(nr,k).autocoor);
    end
    lagm = min(nonzeros(lmax));
    lagmall(count)=lagm;
    meancoor = [];
    varcoor = [];
    lc = [];
    va=[];
    for n=1:lagm
        ltc = 0;
        for nr=1:Nrep%gi
            lc(nr) = cell(nr,k).autocoor(n).*cell(nr,k).lt;
            va(nr) =  cell(nr,k).autocoor(n);
            ltc = ltc+cell(nr,k).lt;
        end
        meancoor(n) = sum(lc)./ltc;
        varcoor(n) = std(va)./sqrt(Nrep);
    end
    meancoor(1) = 1;
    mc{count} = meancoor;
    vc{count} = varcoor;

    y = [y;nonzeros(pt')];
    x = [x;repmat(count,length(nonzeros(pt)),1)];
    loccol = [loccol;repmat(cmap(count,:),length(nonzeros(pt)),1)];
    %med(count) = median(nonzeros(pt));

    med(count) = median(pt);
    frac(count) = (Nrep-length(gi))/Nrep;
    count = count+1;
end
figure(1)
s = swarmchart(x,y,sizespot,loccol,'filled','MarkerFaceAlpha',0.3,'MarkerEdgeAlpha',0)
xticks([1:length(dp)]);
%xtickangle(45);
xticklabels(labels);
hold on
for k=1:length(dp)
plot([k-frac(k)/2 k+frac(k)/2],[0.1 0.1],'color',cmap(k,:),'linewidth',3)
plot(k,med(k),'o','MarkerSize',10,'MarkerFaceColor',cmap(k,:),'MarkerEdgeColor','k')
end
ylabel('Persistence time (hrs)')
set(gca,'FontSize',18,'fontweight','bold')
set(gcf,'color','w');
%s.XJitterWidth = 2.5;
figure(3)
set(gca,'FontSize',18,'fontweight','bold')
set(gcf,'color','w');
yticks([0,0.2,0.4,0.6,0.8,1.0])
yticklabels({'0','0.2','0.4','0.6','0.8','1.0'})
xlim([0 5/60.*min(lagmall)])
ylim([-0.05 1])
ylabel('autocorrelation of direction')
xlabel('Time (hrs)')
hold on
xx=0:min(lagmall)-1;
for k=1:length(dp)
    meancoor = mc{k};
    varcoor = vc{k};
    errorbar(5/60.*xx(2:end),meancoor(2:min(lagmall)),varcoor(2:min(lagmall)),'color', cmap(k,:),'Linewidth',0.5)
    plot(5/60.*xx,(meancoor(1:min(lagmall))),'color',cmap(k,:),'Linewidth',2)
end
